/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.nativesystem;

import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;

public class NativeMethods {
    private static NativeSystem system;
    private static boolean globalAlertInitialized;

    public void isUserDomainUser(NativeResult result) throws NativeException {
        if (!system.isLibraryLoaded()) {
            try {
                system.loadSRVMNativeLibrary();
            }
            catch (NativeException e) {
                Trace.out((String)("Failed to load SRVM library: " + (Object)((Object)e)));
                throw e;
            }
        }
        this.isCurrentUserDomainUser(result);
    }

    private native void isCurrentUserDomainUser(NativeResult var1);

    private native void writeToAlertLog(int var1, String[] var2);

    private native void initClsd();

    private native void termClsd();

    protected void finalize() {
        if (globalAlertInitialized) {
            this.termClsd();
        }
    }

    static {
        globalAlertInitialized = false;
        system = new SystemFactory().CreateSystem();
        try {
            system.loadSRVMNativeLibrary();
        }
        catch (NativeException e) {
            Trace.out((String)("Failed to load SRVM library: " + (Object)((Object)e)));
        }
    }
}

